
#include "include.h"
#include "adc.h"
#include "audio.h"
#include "dtmf.h"



#define TEMP_VALUE_NUMBER 8  // Calculate average over last x samples
                             // Should be a potence of 2 (for cpu-friendl division)!


volatile uint16_t ADC_temp[TEMP_VALUE_NUMBER];



void ADC_Init(void)
// ============================================================================
{ // ADC_Init()

  ADMUX = (0 << REFS1)  // Voltage Reference: AVCC
        | (1 << REFS0)
        | (0 << ADLAR)  // Right adjust
        | (0 << MUX3)   // ADC Input
        | (0 << MUX2)
        | (1 << MUX1)
        | (1 << MUX0);

  ADCSRA = (1 << ADEN)  // Enable
         | (1 << ADSC)  // Start conversion
         | (0 << ADFR)  // Free running
         | (0 << ADIF)  // Interrupt flag
         | (1 << ADIE)  // Interrupt enable
         | (1 << ADPS2) // Prescaler = 16 -> 500 kHz => 13 cycles for 1 measurement => 38,5 samples per ms
         | (0 << ADPS1)
         | (0 << ADPS0);

} // ADC_Init()
// ============================================================================



ISR(ADC_vect)
// ============================================================================
{ // ADC_vect()

  #define AUDIO_CNT 100 // x times audio samples and then one temperature sample...
  static uint8_t sample_cnt;
  static uint8_t temp_pos;

  // Get value
  if(sample_cnt==0)
  {
    temp_pos++;
    if(temp_pos >= TEMP_VALUE_NUMBER)
    {
      temp_pos = 0;
    }
    ADC_temp[temp_pos] = ADC;
  }
  else
  {
    // Handle audio detection#
    #if(WITH_DTMF)
      DTMF_HandleAdcInt(ADC);
    #else
      AUD_CntAdcInt(ADC);
    #endif
  }

  // Set new input and start conversion
  if(sample_cnt >= AUDIO_CNT)
  {
    // Prepare temperature input
    ADMUX = (0 << REFS1)  // Voltage Reference: AVCC
          | (1 << REFS0)
          | (0 << ADLAR)  // Right adjust
          | (0 << MUX3)   // ADC Input
          | (0 << MUX2)
          | (1 << MUX1)
          | (1 << MUX0);

    // Start adc
    ADCSRA |= (1 << ADSC);  // Start conversion

    sample_cnt = 0;
  }
  else
  {
    // Prepare audio input
    ADMUX = (0 << REFS1)  // Voltage Reference: AVCC
          | (1 << REFS0)
          | (0 << ADLAR)  // Right adjust
          | (0 << MUX3)   // ADC Input
          | (0 << MUX2)
          | (0 << MUX1)
          | (0 << MUX0);

    // Start adc
    ADCSRA |= (1 << ADSC);  // Start conversion

    sample_cnt++;
  }

} // ADC_vect()
// ============================================================================



uint16_t ADC_GetTemp(void)
// ============================================================================
{ // ADC_GetTemp()

  uint16_t l_ret = 0;
  uint8_t  l_cnt;

  cli();

  // Sum up all values
  for(l_cnt=0; l_cnt<TEMP_VALUE_NUMBER; l_cnt++)
  {
    l_ret += ADC_temp[l_cnt];
  }

  // Divide through count
  l_ret /= TEMP_VALUE_NUMBER;

  sei();

  return l_ret;

} // ADC_GetTemp()
// ============================================================================
