
// Variants
//#define DK2MO

#if(defined DK2MO)
  #define CALL           "DK2MO"  // Callsign
  #define CW_DOT_LENGTH  70       // [ms] Length of one dot
  #define WITH_ALARM     1        // If input triggers output
#else
  #define CALL           ""
  #define CW_DOT_LENGTH  70       // [ms] Length of one dot
  #define WITH_ALARM     0        // If input triggers output
#endif



// Config
#define F_CPU      8000000
#define WITH_DTMF  0



// Includes
#include <avr/io.h>
#include <util/delay.h>
#include <string.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <stdio.h>
#include <ctype.h>



// Common Defines
#define SET_BIT(var, bit)  var |=  (1<<bit)
#define CLR_BIT(var, bit)  var &= ~(1<<bit)
#define GET_BIT(var, bit)  ((var & (1<<bit)) ? 1 : 0)
#define TOG_BIT(var, bit)  if(GET_BIT(var, bit)){CLR_BIT(var, bit);}else{SET_BIT(var, bit);}
