
// Include Headers
#include "Include.h"



#define FIFO_Init(name, type, size) \
  uint8_t FIFOBUF_##name##_push  = 0;  \
  uint8_t FIFOBUF_##name##_pop   = 0;  \
  uint8_t FIFOBUF_##name##_count = 0;  \
  type FIFOBUF_##name##_data[size];

#define FIFO_Empty(name) \
  (!FIFOBUF_##name##_count)

#define FIFO_Full(name) \
  (FIFOBUF_##name##_count == sizeof(FIFOBUF_##name##_data))

#define FIFO_Push(name, value)                                                         \
  FIFOBUF_##name##_data[FIFOBUF_##name##_push] = value;                                \
  FIFOBUF_##name##_count++;                                                            \
  FIFOBUF_##name##_push++;                                                             \
  if(FIFOBUF_##name##_push >= sizeof(FIFOBUF_##name##_data)) FIFOBUF_##name##_push = 0;

#define FIFO_Pop(name, var)                                                          \
  var = FIFOBUF_##name##_data[FIFOBUF_##name##_pop];                                 \
  FIFOBUF_##name##_count--;                                                          \
  FIFOBUF_##name##_pop++;                                                            \
  if(FIFOBUF_##name##_pop >= sizeof(FIFOBUF_##name##_data)) FIFOBUF_##name##_pop = 0;
